#pragma once

using namespace std;

template <class Type>
class Vector3
{
public:

	Type x;
	Type y;
	Type z;

	Vector3()
	{
		x = 0;
		y = 0;
		z = 0;
	}

	Vector3(Type a, Type b, Type c)
	{
		x = a;
		y = b;
		z = c;
	}

	~Vector3() {}

	void zeroIt()
	{
		x = 0;
		y = 0;
		z = 0;
	}

	float lenght()
	{
		return sqrtf(x*x + y*y + z*z);
	}

	Vector3 reverse()
	{
		return Vector3(1 / x, 1 / y, 1 / z);
	}

	Vector3 &operator += (const Vector3 &a)
	{
		x += a.x;
		y += a.y;
		z += a.z;

		return *this;
	}

	Vector3 &operator -= (const Vector3 &a)
	{
		x -= a.x;
		y -= a.y;
		z -= a.z;

		return *this;
	}

	Vector3 &operator *= (const Vector3 &a)
	{
		x *= a.x;
		y *= a.y;
		z *= a.z;

		return *this;
	}

	Vector3 &operator /= (const Vector3 &a)
	{
		x /= a.x;
		y /= a.y;
		z /= a.z;

		return *this;
	}

	Vector3 operator + (const Vector3 &a) const
	{
		return Vector3(x + a.x, y + a.y, z + a.z);
	}

	Vector3 operator - (const Vector3 &a) const
	{
		return Vector3(x - a.x, y - a.y, z - a.z);
	}
	float operator * (const Vector3 &a) const // iloczyn skalarny
	{	
		return (x * a.x + y * a.y + z * a.z);
	}
	Vector3 operator / (const Vector3 &a) const
	{
		return Vector3(x / a.x, y / a.y, z / a.z);
	}


	//dzialania o skalar
	Vector3 &operator *= (Type s)
	{
		x *= s;
		y *= s;
		z *= s;

		return *this;
	}
	Vector3 &operator /= (Type s)
	{
		x /= s;
		y /= s;
		z /= s;

		return *this;
	}
	Vector3 operator * (Type s) const
	{
		return Vector3(x*s, y*s, z*s);
	}
	Vector3 operator / (Type s) const
	{
		return Vector3(x/s, y/s, z/s);
	}

	Vector3 &operator = (const Vector3 &a)
	{	
		x = a.x;
		y = a.y;
		z = a.z;

		return *this;
	}

	friend ostream &operator << (ostream &os, const Vector3 &a)
	{
		os << a.x << "\t" << a.y << "\t" << a.z;
		return os;
	}
};

